﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Cohorts
{
    public partial class FrameworkData : BasePage
    {
        //private List<REGISTRY_CORE_DATA> Core_Data_List
        //{
        //    get
        //    {
        //        List<REGISTRY_CORE_DATA> coreDataList = null;

        //        if (ViewState["Core_Data_List"] == null)
        //        {
        //            coreDataList = ServiceInterfaceManager.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
        //            ViewState["Core_Data_List"] = coreDataList;
        //        }
        //        else
        //        {
        //            coreDataList = ViewState["Core_Data_List"] as List<REGISTRY_CORE_DATA>;
        //        }

        //        return coreDataList;
        //    }
        //    set
        //    {
        //        ViewState["Core_Data_List"] = value;
        //    }
        //}

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                lblResult.Text = string.Empty;

                if (UserSession == null || UserSession.CurrentRegistryId <= 0)
                {
                    Response.Redirect("~/Cohorts/Default.aspx", false);
                }
                else
                {
                    //BuildCohortsMenu();
                    if (!Page.IsPostBack)
                    {
                        ResetForm();
                        //LoadForm();
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                bool coreSaved = SaveForm();

                //Always attempt to save the Core Data parameters above
                //but don't overwrite other error messages (lblResult.Text)

                if (string.IsNullOrEmpty(lblResult.Text))
                {
                    if (coreSaved)
                        lblResult.Text = "Save successful<br /><br />";
                    else
                        lblResult.Text = "Error saving Core Data parameters, please try again<br /><br />";
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                Response.Redirect("~/Cohorts/FrameworkData.aspx", false);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnReset_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                ResetForm();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnBack_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                bool coreSaved = SaveForm();

                if (coreSaved)
                    Response.Redirect("~/Cohorts/Cohort.aspx", false);
                else
                    lblResult.Text = "Error saving Core Data parameters, please try again<br /><br />";
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnNext_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                bool coreSaved = SaveForm();

                if (coreSaved)
                    Response.Redirect("~/Cohorts/UDF.aspx", false);
                else
                    lblResult.Text = "Error saving Core Data parameters, please try again<br /><br />";
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnAddAll_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                foreach (ListItem li in listSource.Items)
                {
                    li.Selected = true;
                }

                MoveFromSource();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnAddOne_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                MoveFromSource();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnRemOne_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                MoveFromDestination();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnRemAll_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                foreach (ListItem li in listDestination.Items)
                {
                    li.Selected = true;
                }

                MoveFromDestination();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private bool SaveForm()
        {
            bool coreSaved = false;

            List<REGISTRY_CORE_DATA> coreDataList = ServiceInterfaceManager.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            if (coreDataList != null)
            {
                foreach (REGISTRY_CORE_DATA rcd in coreDataList)
                {
                    foreach (ListItem li in listSource.Items)
                    {
                        if (rcd.STD_REGISTRY_CORE_TYPES != null && rcd.STD_REGISTRY_CORE_TYPES.DESCRIPTION_TEXT.Contains(li.Text))
                        {
                            rcd.SELECTED_FLAG = false;
                            break;
                        }
                    }

                    foreach (ListItem li in listDestination.Items)
                    {
                        if (rcd.STD_REGISTRY_CORE_TYPES != null && rcd.STD_REGISTRY_CORE_TYPES.DESCRIPTION_TEXT.Contains(li.Text))
                        {
                            rcd.SELECTED_FLAG = true;
                            break;
                        }
                    }
                }

                coreSaved = ServiceInterfaceManager.REGISTRY_CORE_DATA_SAVE_LIST(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, coreDataList);
            }

            return coreSaved;
        }

        private void ResetForm()
        {
            listSource.Items.Clear();
            listDestination.Items.Clear();

            //Populate Source List Box
            List<REGISTRY_CORE_DATA> coreDataList = ServiceInterfaceManager.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            if (coreDataList != null)
            {
                listSource.DataSource = coreDataList.Where(data => data.STD_REGISTRY_CORE_TYPES.TABLE_NAME != "CUSTOM").GroupBy(where => where.STD_REGISTRY_CORE_TYPES.DESCRIPTION_TEXT).Select(group => group.FirstOrDefault().STD_REGISTRY_CORE_TYPES.DESCRIPTION_TEXT);
                listSource.DataBind();

                foreach (ListItem li in listSource.Items)
                {
                    foreach (REGISTRY_CORE_DATA rcd in coreDataList)
                    {
                        if (rcd.STD_REGISTRY_CORE_TYPES != null && rcd.STD_REGISTRY_CORE_TYPES.DESCRIPTION_TEXT.Contains(li.Text))
                        {
                            li.Selected = rcd.SELECTED_FLAG;
                            break;
                        }
                    }
                }

                MoveFromSource();
            }
        }

        private void MoveFromSource()
        {
            int index = listDestination.Items.Count;

            for (int i = listSource.Items.Count - 1; i >= 0; i--)
            {
                if (listSource.Items[i].Selected)
                {
                    string category = listSource.Items[i].Text;
                    listDestination.Items.Insert(index, new ListItem(category, category));
                    listSource.Items.RemoveAt(i);
                }
            }
        }

        private void MoveFromDestination()
        {
            int index = listSource.Items.Count;

            for (int i = listDestination.Items.Count - 1; i >= 0; i--)
            {
                if (listDestination.Items[i].Selected)
                {
                    string category = listDestination.Items[i].Text;
                    listSource.Items.Insert(index, new ListItem(category, category));
                    listDestination.Items.RemoveAt(i);
                }
            }
        }
    }
}